'''Generates the byte array for setting the global brightness.'''
def CMD_Set_BC(brightness):
	barray = bytearray.fromhex('7E 00 02 0A')
	barray.extend([brightness])
	barray.extend([Calculate_Checksum(barray)])
	return barray

'''Generates the byte array for clearing all pixels.'''
def CMD_Clear():
	return bytearray.fromhex('7E 00 01 0B F4')

'''Generates the command for setting a specific pixel.'''
def CMD_Set_Pixel(layer, row, column, r, g, b):
	barray = bytearray.fromhex('7E 00 07 10')
	barray.extend([layer,row,column,r,g,b,])
	barray.extend([Calculate_Checksum(barray)])
	return barray

'''Generates the command for setting the entire cube.'''
def CMD_Set_All(leds):
	barray = bytearray.fromhex('7E 09 01 11')
	barray.extend(leds)
	barray.extend([Calculate_Checksum(barray)])
	return barray

'''Generates the command for setting the rotating overlay text.'''
def CMD_Start_Text(r, g, b, string):
	length = len(string) + 4
	barray = bytearray.fromhex('7E 00') 
	barray.extend([length, 0x20, r, g, b])
	barray.extend(string.encode())
	barray.extend([Calculate_Checksum(barray)])
	return barray

'''Generates the command for stopping the rotating overlay text.'''
def CMD_Stop_Text():
	return bytes.fromhex('7E 00 01 21 DE')

def Calculate_Checksum(barray):
	s = 0
	for entry in range(3,len(barray)):
		s += barray[entry]
	return 255 - (s & 0xFF)